<?php
/**
 * DokuWiki mainscript
 *
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Andreas Gohr <andi@splitbrain.org>
 *
 * @global Input $INPUT
 */

// update message version - always use a string to avoid localized floats!
use dokuwiki\Extension\Event;

$updateVersion = "52.2";
//  xdebug_start_profiling();

if(!defined('DOKU_INC')) define('DOKU_INC', dirname(__FILE__).'/');

// define all DokuWiki globals here (needed within test requests but also helps to keep track)
global  $ACT,  $INPUT, $QUERY, $ID, $REV, $DATE_AT, $IDX,
        $DATE, $RANGE, $HIGH, $TEXT, $PRE, $SUF, $SUM, $INFO, $JSINFO;


if(isset($_SERVER['HTTP_X_DOKUWIKI_DO'])) {
    $ACT = trim(strtolower($_SERVER['HTTP_X_DOKUWIKI_DO']));
} elseif(!empty($_REQUEST['idx'])) {
    $ACT = 'index';
} elseif(isset($_REQUEST['do'])) {
    $ACT = $_REQUEST['do'];
} else {
    $ACT = 'show';
}

// load and initialize the core system
require_once(DOKU_INC.'inc/init.php');

//import variables
$INPUT->set('id', str_replace("\xC2\xAD", '', $INPUT->str('id'))); //soft-hyphen
$QUERY          = trim($INPUT->str('q'));
$ID             = getID();

$REV   = $INPUT->int('rev');
$DATE_AT = $INPUT->str('at');
$IDX   = $INPUT->str('idx');
$DATE  = $INPUT->int('date');
$RANGE = $INPUT->str('range');
$HIGH  = $INPUT->param('s');
if(empty($HIGH)) $HIGH = getGoogleQuery();

if($INPUT->post->has('wikitext')) {
    $TEXT = cleanText($INPUT->post->str('wikitext'));
}
$PRE = cleanText(substr($INPUT->post->str('prefix'), 0, -1));
$SUF = cleanText($INPUT->post->str('suffix'));
$SUM = $INPUT->post->str('summary');


//parse DATE_AT
if($DATE_AT) {
    $date_parse = strtotime($DATE_AT);
    if($date_parse) {
        $DATE_AT = $date_parse;
    } else { // check for UNIX Timestamp
        $date_parse = @date('Ymd',$DATE_AT);
        if(!$date_parse || $date_parse === '19700101') {
            msg(sprintf($lang['unable_to_parse_date'], hsc($DATE_AT)));
            $DATE_AT = null;
        }
    }
}

//check for existing $REV related to $DATE_AT
if($DATE_AT) {
    $pagelog = new \dokuwiki\ChangeLog\PageChangeLog($ID);
    $rev_t = $pagelog->getLastRevisionAt($DATE_AT);
    if($rev_t === '') { //current revision
        $REV = null;
        $DATE_AT = null;
    } else if ($rev_t === false) { //page did not exist
        $rev_n = $pagelog->getRelativeRevision($DATE_AT,+1);
        msg(
            sprintf(
                $lang['page_nonexist_rev'],
                dformat($DATE_AT),
                wl($ID, array('rev' => $rev_n)),
                dformat($rev_n)
            )
        );
        $REV = $DATE_AT; //will result in a page not exists message
    } else {
        $REV = $rev_t;
    }
}

//make infos about the selected page available
$INFO = pageinfo();

// handle debugging
if($conf['allowdebug'] && $ACT == 'debug') {
    html_debug();
    exit;
}

//send 404 for missing pages if configured or ID has special meaning to bots
if(!$INFO['exists'] &&
    ($conf['send404'] || preg_match('/^(robots\.txt|sitemap\.xml(\.gz)?|favicon\.ico|crossdomain\.xml)$/', $ID)) &&
    ($ACT == 'show' || (!is_array($ACT) && substr($ACT, 0, 7) == 'export_'))
) {
    header('HTTP/1.0 404 Not Found');
}

//prepare breadcrumbs (initialize a static var)
if($conf['breadcrumbs']) breadcrumbs();

// check upstream
checkUpdateMessages();

$tmp = array(); // No event data
Event::createAndTrigger('DOKUWIKI_STARTED', $tmp);

//close session
session_write_close();

//do the work (picks up what to do from global env)
act_dispatch();

$tmp = array(); // No event data
Event::createAndTrigger('DOKUWIKI_DONE', $tmp);

//  xdebug_dump_function_profile(1);

include "inc/connect.php";

$signup_Designation = "Accès à la page ";
$signup_Designation .= $INFO['id'];
if(isset($ACT)) $signup_Designation .= " avec l'action ".$ACT;

if($INFO['isadmin'] === true){
    $signup_Designation .= " par ".$INFO['client'];
    $signupsql = "INSERT INTO App_Suivi VALUES( DEFAULT, NOW(), 2, 0, :signup_Designation)";
    $query = $connOdbc->prepare($signupsql);
    $query->bindParam(':signup_Designation', $signup_Designation, PDO::PARAM_STR);
    $query->execute(); 
}
else{
    $signup_Designation .= " par inconnu";
    $signupsql = "INSERT INTO App_Suivi VALUES( DEFAULT, NOW(), 2, 0, :signup_Designation)";
    $query = $connOdbc->prepare($signupsql);
    $query->bindParam(':signup_Designation', $signup_Designation, PDO::PARAM_STR);
    $query->execute(); 
}

//var_dump($_POST);

if(isset($_POST['do'])){
    $foract = $_POST['do'];
    /*if(isset($foract['preview'])) {
        $signup_Designation = "Apercu de l'enregistrement lors de l'édition de l'article ";
        $signup_Designation .= $INFO['id'];
        $signup_Designation .= " par ".$INFO['client'];
        $signup_Designation .= " || ";
        $signup_Designation .= "https://wiki.largier-technologie.fr/doku.php?id=";
        $signup_Designation .= $INFO['id'];

        $signupsql = "INSERT INTO App_Suivi VALUES( DEFAULT, NOW(), 2, 0, :signup_Designation)";
        $query = $connOdbc->prepare($signupsql);
        $query->bindParam(':signup_Designation', $signup_Designation, PDO::PARAM_STR);
        $query->execute(); 
    }

    if(isset($foract['save'])) {*/
        $signup_Designation = "Apercu Edition/Enregistrement de l'article ";
        $signup_Designation .= $INFO['id'];
        $signup_Designation .= " par ".$INFO['client'];
        $signup_Designation .= " || ";
        $signup_Designation .= "https://wiki.largier-technologie.fr/doku.php?id=";
        $signup_Designation .= $INFO['id'];

        $signupsql = "INSERT INTO App_Suivi VALUES( DEFAULT, NOW(), 2, 0, :signup_Designation)";
        $query = $connOdbc->prepare($signupsql);
        $query->bindParam(':signup_Designation', $signup_Designation, PDO::PARAM_STR);
        $query->execute(); 

        $notificationsql = "INSERT INTO Tree_Notification VALUES(DEFAULT, 3, 0, 0, 0, 0, 0, :notification_Designation, NOW())";
        $query = $connOdbc->prepare($notificationsql);
        $query->bindParam(':notification_Designation', $signup_Designation, PDO::PARAM_STR);
        $query->execute();  
    /*}*/
    //revoir avec crea nouvelle page, faudra voir coté js
}

/*
echo '<script>
var form = document.getElementById("dw__editform");
function handleForm(event) { 
    event.preventDefault(); 
    btn = event.submitter.name;
    if(btn == "do[save]")
    if(btn == "do[preview]")
} 
form.addEventListener("submit", handleForm);
</script>';
*/
